# -*- coding: utf-8 -*-
"""r14.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1ZQnxOGm2MMLZ0n8mxnhZLjWRYHBlZrso
"""

import numpy as np
import matplotlib.pyplot as plt

# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Rozkład według wartości osobliwych"""

A = np.random.randn(4,6)

U,s,Vt = np.linalg.svd(A)

S = np.zeros(np.shape(A))
np.fill_diagonal(S,s)


_,axs = plt.subplots(1,4,figsize=(10,6))

axs[0].imshow(A,cmap='gray',aspect='equal')
axs[0].set_title('$\mathbf{A}$\nMacierz')

axs[1].imshow(U,cmap='gray',aspect='equal')
axs[1].set_title('$\mathbf{U}$\nLewostronne\nwektory\nosobliwe')

axs[2].imshow(S,cmap='gray',aspect='equal')
axs[2].set_title('$\mathbf{\Sigma}$\nWartości\nosobliwe')

axs[3].imshow(Vt,cmap='gray',aspect='equal')
axs[3].set_title('$\mathbf{V}$\nPrawostronne\nwektory\nosobliwe')

plt.tight_layout()
plt.savefig('rys14.2.png',dpi=300)
plt.show()



"""# Macierz symetryczna"""

A = np.random.randn(5,5)
A = A.T@A

eigvals = np.linalg.eig(A)[0]
sinvals = np.linalg.svd(A)[1]

print(np.sort(eigvals))
print(np.sort(sinvals))



"""# Ćwiczenie 1."""

# tworzę macierz symetryczną
A = np.random.randn(5,5)
A = A.T@A
# A = A+A.T # odkomentuj tę linię, aby powtórzyć obliczenia dla A+A'

# rozkład według wartości własnych
evals,evecs = np.linalg.eig(A)

# sortowanie ułatwi porównanie!
sidx  = np.argsort(evals)[::-1]
evals = evals[sidx]
evecs = evecs[:,sidx]



# rozkład według wartości osobliwych
U,s,Vt = np.linalg.svd(A)

print('Wartość własne i osobliwe:')
print(np.vstack((evals,s)).T)

print(f'\nRóżnica pomiędzy lewo- i prawostronnymi wektorami osobliwymi (powinna wynosić 0)')
print(np.round(U-Vt.T,10)) # pamiętaj aby porównać z V, a nie z V^T!

print(f'\nRóżnica pomiędzy wektorami osobliwymi i własnymi (powinna wynosić  0)')
print(np.round(U-evecs,10))
print(' ')
print(np.round(U+evecs,10)) # na potrzeby różnic w znakach



"""# Ćwiczenie 2."""

# rozmiary (sprawdź wysokie i szerokie macierze)
m = 10
n = 4

# macierz wartości losowych i jej zredukowany rozkład według wartości osobliwych
A = np.random.randn(m,n)
U,s,Vt = np.linalg.svd(A,full_matrices=False)

print(f'Rozmiar A:  {A.shape}')
print(f'Rozmiar U:  {U.shape}')
print(f"Rozmiar V': {Vt.shape}")



"""# Ćwiczenie 3."""

# dowód tego, że |Uw|=|w| otrzymuje się zapisując wzór na długość wektora korzystając z iloczynu skalarnego
# |Uw|^2 = (Uw)'(Uw) = w'U'U'w = w'Iw = w'w = |w|^2


# przykład:
U,s,Vt = np.linalg.svd(np.random.randn(5,5))
w = np.random.randn(5,1)

# wyświetlam normy
print( np.linalg.norm(U@w) )
print( np.linalg.norm(  w) )



"""# Ćwiczenie 4."""

# tworzą wysoką macierz o określonym współczynniku uwarunkowania
m = 10
n = 6

condnum = 42

# tworzę U i V
U,_  = np.linalg.qr( np.random.randn(m,m) )
Vt,_ = np.linalg.qr( np.random.randn(n,n) )

# tworzę wektor wartości osobliwych
s = np.linspace(condnum,1,np.min((m,n)))

# zamieniam go w macierz
S = np.zeros((m,n))
np.fill_diagonal(S,s)

# wyznaczam macierz A
A = U@S@Vt

# tworzę wykres
_,axs = plt.subplots(1,4,figsize=(12,6))

axs[0].imshow(A, aspect='equal', cmap='gray')
axs[0].set_title(f'A (cond={np.linalg.cond(A):.3f})')

axs[1].imshow(U, aspect='equal', cmap='gray')
axs[1].set_title(f'U (cond={np.linalg.cond(U):.3f})')

axs[2].imshow(S, aspect='equal', cmap='gray')
axs[2].set_title(f'$\Sigma$ (cond={np.linalg.cond(S):.3f})')

axs[3].imshow(Vt, aspect='equal', cmap='gray')
axs[3].set_title(f'V$^T$ (cond={np.linalg.cond(Vt):.3f})')


plt.tight_layout()
plt.savefig('rys14.4.png',dpi=300)
plt.show()



"""# Ćwiczenie 5."""

# tworzę macierz
m = 40
n = 30

# definiuję dwuwymiarowy rozkład normalny na potrzeby wygładzania
k = int((m+n)/4)
X,Y = np.meshgrid(np.linspace(-3,3,k),np.linspace(-3,3,k))
g2d = np.exp( -(X**2 + Y**2)/(k/8) )


# konwolucja
from scipy.signal import convolve2d
A = convolve2d(np.random.randn(m,n),g2d,mode='same')


# rozkład oraz macierz Sigma
U,s,Vt = np.linalg.svd(A)
S = np.zeros(np.shape(A))
np.fill_diagonal(S,s)


# wizualizacja

_,axs = plt.subplots(1,4,figsize=(12,6))

axs[0].imshow(A, aspect='equal', cmap='gray', vmin=-10,vmax=10)
axs[0].set_title('A')

axs[1].imshow(U, aspect='equal', cmap='gray')
axs[1].set_title('U')

axs[2].imshow(S, aspect='equal', cmap='gray')
axs[2].set_title('$\Sigma$')

axs[3].imshow(Vt, aspect='equal', cmap='gray')
axs[3].set_title('V$^T$')


plt.tight_layout()
plt.savefig('rys14.5a.png',dpi=300)
plt.show()


plt.figure(figsize=(12,3))
plt.plot(100*s/np.sum(s),'ks-',markersize=10)
plt.xlabel('Numer składowej')
plt.ylabel('Procent wyjaśnianej wariancji')
plt.title('Wykres osypiska')
plt.savefig('rys14.5b.png',dpi=300, bbox_inches='tight')
plt.show()

## wyświetlam pierwsze N warstw: osobno i w postaci skumulowanej

numLayers = 4
rank1mats = np.zeros((numLayers,m,n))


# przygotowanie rysunku
_,axs = plt.subplots(2,numLayers,figsize=(10,6))

# pętla
for i in range(numLayers):

    # tworzę warstwę
    rank1mats[i,:,:] = np.outer(U[:,i],Vt[i,:])*S[i,i]

    # wyświetlam warstwę
    axs[0,i].imshow(rank1mats[i,:,:],cmap='gray', vmin=-10,vmax=10)
    axs[0,i].set_title(f'L {i}')
    axs[0,i].set_xticks([]), axs[0,i].set_yticks([])

    # wyświetla skumulowaną sumę warstw
    axs[1,i].imshow(np.sum(rank1mats[:i+1,:,:],axis=0),cmap='gray', vmin=-10,vmax=10)
    axs[1,i].set_title(f'L 0:{i}')
    axs[1,i].set_xticks([]), axs[1,i].set_yticks([])


plt.tight_layout()
plt.savefig('rys14.5c.png',dpi=300)
plt.show()



"""# Ćwiczenie 6."""

# macierz osobliwa
A = np.random.randn(5,3) @ np.random.randn(3,5)

# jej rozkład według wartości osobliwych
U,s,Vt = np.linalg.svd(A)

# musisz określić próg (tolerancję) dla „zerowych” wartości osobliwych
# myślałem, aby powiązać ją z rozmiarem A
# W numPy zastosowano stałą wartość 10^-15, co oznacza, że nie dostosowuje się ona do precyzji obliczeń
tol = np.finfo(float).eps * np.max(A.shape)

# odwracam sigmy powyżej progu
sInv = np.zeros_like(s)
sInv[s>tol] = 1/s[s>tol]

# rekonstrukcja
S = np.zeros_like(A)
np.fill_diagonal(S,sInv)
Apinv = Vt.T @ S @ U.T

# porównanie z pinv()
ApinvNp = np.linalg.pinv(A)

print(np.round( ApinvNp - Apinv ,5))

# kod źródłowy funkcji pinv
??np.linalg.pinv()



"""# Ćwiczenie 7."""

# odwrotność lewostronna
A = np.random.randn(6,4)

# jawnie wyznaczam odwrotność lewostronną
Linv = np.linalg.inv(A.T@A)@A.T

# pinv
Apinv = np.linalg.pinv(A)

# porównanie
print(np.round( Linv - Apinv ,5))

# odwrotność prawostronna
A = np.random.randn(4,6)

# jawnie wyznaczam odwrotność prawostronną
Rinv = A.T@np.linalg.inv(A@A.T)

# pinv
Apinv = np.linalg.pinv(A)

# porównanie
print(np.round( Rinv - Apinv ,5))



"""# Ćwiczenie 8."""

# macierz (z rozdziału 12.)
M = np.array([ [-1,1],
               [-1,2] ])

# jej rozkład według wartości własnych
evals,evecs = np.linalg.eig(M)
l = evals[1]     # dla wygody zapisuję lambda1 w osobnej zmiennej
v = evecs[:,[1]] # dla wygody zapisuję wektor własny związany z lambda1 w osobnej zmiennej

LHS = M@v
RHS = l*v

# wyświetlam obie strony (dla wygodny w postaci wektorów wierszowych)
print(LHS.T)
print(RHS.T)

# pinv(v)
vPinv = np.linalg.pinv(v)

# sprawdzam
vPinv@v

# pierwsze równanie
LHS = vPinv @ M @ v
RHS = l * vPinv @ v

# wyniki są skalarami (forma kwadratowa)
print(LHS)
print(RHS)

# drugie równanie
LHS = M @ v @ vPinv
RHS = l * v @ vPinv

# tym razem wyniki są macierzami
print(LHS), print(' ')
print(RHS)

